﻿© Fluke Calibration. All Rights Reserved.                  MET/CAL Procedure
=============================================================================
INSTRUMENT:            Excel Example: R&S FSV Level Unc. Calculation Example
DATE:                  2011-12-14 17:37:00
AUTHOR:                Fluke Calibration
REVISION:              $Revision: $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       151
=============================================================================
#
# This procedure requires Microsoft Excel to be installed on the computer.
#
# For information on the Excel application COM object, refer to
# the following link:
#
# http://msdn.microsoft.com/en-us/library/microsoft.office.interop.excel.aspx
#
# This procedure demonstrates the use of local named variables and
# numeric literals with the LIB FSC.  Required data is written to an OEM
# uncertainty calculation spreadsheet, the spreadsheet performs the
# calculation, then the result is returned to MET/CAL for further use.
#
# Required subprocedure(s):
#        Sub xlApp: Disable Prompts and Exit Excel
#
# Required file(s):
#        1EF63_FSV_Level_Uncertainty.xls (embedded in Project)
#        Version 1, Last modified: 25.01.2010
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  HEAD         R&S FSV LEVEL UNCERTAINTY CALCULATION EXAMPLE

# Store the path to the Excel file embedded into the Editor Project.
  1.002  MATH         xlFile = PXETEMP() & "1EF63_FSV_Level_Uncertainty.xls"

# Launch MS Excel and make it visible.
  1.003  LIB          COM xlApp = "Excel.Application";
  1.004  LIB          xlApp.Visible = True;

# Specify a clear operation for this procedure, which will automatically
# execute when the procedure terminates.
  1.005  CLEAR        -c Sub xlApp: Disable Prompts and Exit Excel

# Open workbook.
  1.006  LIB          COM xlWB = xlApp.Workbooks;
  1.007  LIB          xlWB.Open(xlFile);

# Select worksheet.
  1.008  LIB          COM xlWS = xlApp.Worksheets["General Table"];
  1.009  LIB          xlWS.Select();

# -----  Instantiate COM objects for target cells.

# Absolute error @ 128 MHz [dB]
  1.010  LIB          COM cell_AbsErr      = xlApp.Range["B4"];
# Frequency response [dB]
  1.011  LIB          COM cell_FR          = xlApp.Range["B5"];
# Input attenuator switching [dB]
  1.012  LIB          COM cell_InpAtten    = xlApp.Range["B6"];
# IF Gain switching [dB]
  1.013  LIB          COM cell_IFGain      = xlApp.Range["B7"];
# Display linearity [dB]
  1.014  LIB          COM cell_DisplayLin  = xlApp.Range["B8"];
# Bandwidth switching error [dB]
  1.015  LIB          COM cell_BWSwitching = xlApp.Range["B9"];
# Resolution Bandwidth error [%]
  1.016  LIB          COM cell_RBWError    = xlApp.Range["B10"];
# VSWR of SA
  1.017  LIB          COM cell_VSWR_SA     = xlApp.Range["B16"];
# VSWR of DUT
  1.018  LIB          COM cell_VSWR_DUT    = xlApp.Range["B17"];

# -----  Create a simulated data set for the first test point.

# Simulate values for all parameters that are required by the spreadsheet.
  1.019  MATH         AbsError_128MHz   = 0.2 + 0.1
  1.020  MATH         FreqResponse      = 0.3 + 0.1
  1.021  MATH         InpAttenSwitching = 0.2 + 0.1
  1.022  MATH         IFGainSwitching   = 0.0 + 0.1
  1.023  MATH         DisplayLin        = 0.1 + 0.1
  1.024  MATH         BWSwitchingError  = 0.1 + 0.1
  1.025  MATH         RBWError          = 3.0 + 0.1
  1.026  MATH         VSWR_SA           = 1.5 + 0.1
  1.027  MATH         VSWR_DUT          = 1.5 + 0.1

# Write data set 1's values to spreadsheet.
  1.028  LIB          cell_AbsErr.Value2      = AbsError_128MHz;
  1.029  LIB          cell_FR.Value2          = FreqResponse;
  1.030  LIB          cell_InpAtten.Value2    = InpAttenSwitching;
  1.031  LIB          cell_IFGain.Value2      = IFGainSwitching;
  1.032  LIB          cell_DisplayLin.Value2  = DisplayLin;
  1.033  LIB          cell_BWSwitching.Value2 = BWSwitchingError;
  1.034  LIB          cell_RBWError.Value2    = RBWError;
  1.035  LIB          cell_VSWR_SA.Value2     = VSWR_SA;
  1.036  LIB          cell_VSWR_DUT.Value2    = VSWR_DUT;

# Force spreadsheet to recalculate.
  1.037  LIB          xlApp.Calculate();

# Retreive the description text from cell A20.
  1.038  LIB          COM cell_Desc = xlApp.Range["A20"];
  1.039  LIB          Desc = cell_Desc.Value2;

# Store and format data set 1's calculated result from cell C20.
  1.040  LIB          COM cell_Error = xlApp.Range["C20"];
  1.041  LIB          Error1 = cell_Error.Value2;
  1.042  MATH         Error1 = FMT(Error1, "%4.3f")

# -----  Create a simulated data set for the first test point.

# Simulate values for all parameters that are required by the spreadsheet.
  1.043  MATH         AbsError_128MHz   = 0.2 - 0.1
  1.044  MATH         FreqResponse      = 0.3 - 0.1
  1.045  MATH         InpAttenSwitching = 0.2 - 0.1
  1.046  MATH         IFGainSwitching   = 0.0 - 0.1
  1.047  MATH         DisplayLin        = 0.1 - 0.1
  1.048  MATH         BWSwitchingError  = 0.1 - 0.1
  1.049  MATH         RBWError          = 3.0 - 0.1
  1.050  MATH         VSWR_SA           = 1.5 - 0.1
  1.051  MATH         VSWR_DUT          = 1.5 - 0.1

# Write data set 1's values to spreadsheet.
  1.052  LIB          cell_AbsErr.Value2      = AbsError_128MHz;
  1.053  LIB          cell_FR.Value2          = FreqResponse;
  1.054  LIB          cell_InpAtten.Value2    = InpAttenSwitching;
  1.055  LIB          cell_IFGain.Value2      = IFGainSwitching;
  1.056  LIB          cell_DisplayLin.Value2  = DisplayLin;
  1.057  LIB          cell_BWSwitching.Value2 = BWSwitchingError;
  1.058  LIB          cell_RBWError.Value2    = RBWError;
  1.059  LIB          cell_VSWR_SA.Value2     = VSWR_SA;
  1.060  LIB          cell_VSWR_DUT.Value2    = VSWR_DUT;

# Force spreadsheet to recalculate.
  1.061  LIB          xlApp.Calculate();

# Store and format data set 1's calculated result from cell C20.
  1.062  LIB          Error2 = cell_Error.Value2;
  1.063  MATH         Error2 = FMT(Error2, "%4.3f")

# Display the formatted results for Data Set 1 and 2.
  1.064  DISP         The values read from the spreadsheet are:
  1.064  DISP
  1.064  DISP         [V Desc]:
  1.064  DISP
  1.064  DISP         Data set 1: [V Error1] dB
  1.064  DISP         Data set 2: [V Error2] dB

  1.065  HEAD
  1.066  END